% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.user.watched.R
\name{trakt.user.watched}
\alias{trakt.user.watched}
\title{Get a user's watched shows or movies}
\usage{
trakt.user.watched(user = getOption("trakt.username"), type = "shows")
}
\arguments{
\item{user}{Target user. Defaults to \code{getOption("trakt.username")}}

\item{type}{Either \code{shows} (default), \code{shows.extended} or \code{movies}}
}
\value{
A \code{data.frame} containing stats.
if \code{type} is set to \code{shows.extended}, the resulting \code{data.frame}
contains play stats for _every_ watched episode of _every_ show. Otherwise,
the returned \code{data.frame} only contains play stats per show or movie respectively.
}
\description{
\code{trakt.user.watched} pulls a user's watched shows or movies.
It does not use OAuth2, so you can only get data for a user with a
public profile.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/users/watched/get-watched}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
myshows     <- trakt.user.watched() # Defaults to your username if set
seans.shows <- trakt.user.watched(user = "sean")
}
}

