% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_row_css.R
\name{add_css_row}
\alias{add_css_row}
\title{Add css to tableHTML's rows}
\usage{
add_css_row(tableHTML, css, rows = NULL)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}

\item{rows}{A numeric atomic vector with the indices of the rows on which the style definitions
will be applied. headers and second_headers are included in the rows.Default is NULL
which means that it will be applied to all rows.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_row} will add css to a tableHTML's rows
}
\details{
\code{add_css_row} will add css to a tableHTML's rows. The only thing you need to be cautious 
about is the rows argument. \code{headers} and \code{second_headers} are still considered rows.
\code{add_css_row} affects the tr tag of the HTML code internally.
}
\examples{
tableHTML(mtcars) \%>\% 
  add_css_row(css = list(c('background-color', 'border'), c('lightgray', '3px solid green'))) 

tableHTML(mtcars) \%>\% 
  add_css_row(css = list(c('background-color', 'border'), c('lightgray', '3px solid green')), 
              rows = 1:33)
        
}

