% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyCreateTableOne.R
\name{svyCreateTableOne}
\alias{svyCreateTableOne}
\title{Create an object summarizing both continuous and categorical variables for weighted data}
\usage{
svyCreateTableOne(
  vars,
  strata,
  data,
  factorVars,
  includeNA = FALSE,
  test = TRUE,
  testApprox = svyTestChisq,
  argsApprox = NULL,
  testNormal = svyTestNormal,
  argsNormal = list(method = "Wald"),
  testNonNormal = svyTestNonNormal,
  argsNonNormal = NULL,
  smd = TRUE,
  addOverall = FALSE
)
}
\arguments{
\item{vars}{Variables to be summarized given as a character vector. Factors are handled as categorical variables, whereas numeric variables are handled as continuous variables. If empty, all variables in the survey design object specified in the data argument are used.}

\item{strata}{Stratifying (grouping) variable name(s) given as a character vector. If omitted, the overall results are returned.}

\item{data}{A survey design object in which these variables exist. All variables (both vars and strata) must be in this survey design object. It is created with the \code{svydesign} function in the \code{survey} package.}

\item{factorVars}{Numerically coded variables that should be handled as categorical variables given as a character vector. Do not include factors, unless you need to relevel them by removing empty levels. If omitted, only factors are considered categorical variables. The variables specified here must also be specified in the \code{vars} argument.}

\item{includeNA}{If TRUE, NA is handled as a regular factor level rather than missing. NA is shown as the last factor level in the table. Only effective for categorical variables.}

\item{test}{If TRUE, as in the default and there are more than two groups, groupwise comparisons are performed.}

\item{testApprox}{A function used to perform the large sample approximation based tests. The default is \code{svychisq}.}

\item{argsApprox}{A named list of arguments passed to the function specified in testApprox.}

\item{testNormal}{A function used to perform the normal assumption based tests. The default is multiple degrees of freedom test using \code{svyglm} and \code{regTermTest}. This is equivalent of the \code{svyttest} when there are only two groups.}

\item{argsNormal}{A named list of arguments passed to the function specified in \code{testNormal}.}

\item{testNonNormal}{A function used to perform the nonparametric tests. The default is \code{svyranktest}.}

\item{argsNonNormal}{A named list of arguments passed to the function specified in \code{testNonNormal}.}

\item{smd}{If TRUE, as in the default and there are more than two groups, standardized mean differences for all pairwise comparisons are calculated.}

\item{addOverall}{(optional, only used if strata are supplied) Adds an overall column to the table. Smd and p-value calculations are performed using only the stratifed clolumns.}
}
\value{
An object of class \code{svyTableOne}, which is a list of three objects.

\item{ContTable}{an object of class \code{svyContTable}, containing continuous variables only}

\item{CatTable}{ an object of class \code{svyCatTable}, containing categorical variables only}

\item{MetaData}{list of metadata regarding variables}
}
\description{
Create an object summarizing all baseline variables (both continuous and categorical) optionally stratifying by one or more startifying variables and performing statistical tests. The object gives a table that is easy to use in medical research papers.
}
\details{
See the details for \code{\link{CreateTableOne}}.
}
\examples{

## Load packages
library(tableone)
library(survey)

## Create a weighted survey design object
data(nhanes)
nhanesSvy <- svydesign(ids = ~ SDMVPSU, strata = ~ SDMVSTRA, weights = ~ WTMEC2YR,
                       nest = TRUE, data = nhanes)

## Create a table object
## factorVars are converted to factors; no need for variables already factors
## strata will stratify summaries; leave it unspecified for overall summaries
tab1 <- svyCreateTableOne(vars = c("HI_CHOL","race","agecat","RIAGENDR"),
                          strata = "RIAGENDR", data = nhanesSvy,
                          factorVars = c("race","RIAGENDR"))

## Detailed output
summary(tab1)

## Default formatted printing
tab1

## nonnormal specifies variables to be shown as median [IQR]
print(tab1, nonnormal = "HI_CHOL", contDigits = 3, catDigits = 2,
      pDigits = 4, smd = TRUE)

## minMax changes it to median [min, max]
print(tab1, nonnormal = "HI_CHOL", minMax = TRUE, contDigits = 3,
      catDigits = 2, pDigits = 4, smd = TRUE)

## showAllLevels can be used tow show levels for all categorical variables
print(tab1, showAllLevels = TRUE, smd = TRUE)

## To see all printing options
?print.TableOne

## To examine categorical variables only
tab1$CatTable

## To examine continuous variables only
tab1$ContTable

## If SMDs are needed as numericals, use ExtractSmd()
ExtractSmd(tab1)

}
\seealso{
\code{\link{print.TableOne}}, \code{\link{summary.TableOne}}
}
\author{
Kazuki Yoshida
}
