% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{tablerInfoCard}
\alias{tablerInfoCard}
\title{Create a Boostrap 4 info card}
\usage{
tablerInfoCard(value, description = NULL, status, icon, href = NULL,
  width = 4)
}
\arguments{
\item{value}{Card value.}

\item{description}{Percentage increase/decrease.}

\item{status}{Card status. See \url{https://preview.tabler.io/docs/colors.html}.}

\item{icon}{Card icon.}

\item{href}{External link.}

\item{width}{Card width. 4 by default.}
}
\description{
Build a tabler info card
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerInfoCard(
      value = "132 sales",
      status = "danger",
      icon = "dollar-sign",
      description = "12 waiting payments"
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
