% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note-checks}
\alias{note-checks}
\alias{note_is_accidental}
\alias{note_is_natural}
\alias{note_is_flat}
\alias{note_is_sharp}
\alias{note_has_accidental}
\alias{note_has_natural}
\alias{note_has_flat}
\alias{note_has_sharp}
\title{Basic noteworthy string checks}
\usage{
note_is_accidental(notes)

note_is_natural(notes)

note_is_flat(notes)

note_is_sharp(notes)

note_has_accidental(notes)

note_has_natural(notes)

note_has_flat(notes)

note_has_sharp(notes)
}
\arguments{
\item{notes}{character, a noteworthy string.}
}
\value{
logical
}
\description{
The simplest functions for inspecting noteworthy strings to see if their
notes have certain properties.
}
\details{
Note that these functions are the weakest in terms of checking
noteworthiness. They are simple regular expression-based wrappers. They are
often used internally by more complex functions without wasting computational
overhead on performing input validity checks, but they are exported from the
package for user convenience. Their results will only make sense on strings
that you define in accordance with noteworthy string rules.

The \code{note_is_*} functions return a logical vector with length equal to
the number of timesteps in \code{notes}.
The \code{note_has_*} functions summarize these to a single logical value.
}
\examples{
x <- "r a_2 a a#' s"
note_has_accidental(x)
note_has_natural(x)
note_has_flat(x)
note_has_sharp(x)
note_is_accidental(x)
note_is_natural(x)
note_is_flat(x)
note_is_sharp(x)
note_has_tick(x)
note_has_integer(x)
note_is_tick(x)
note_is_integer(x)
note_has_rest(x)
note_is_rest(x)
}
\seealso{
\code{\link{note-metadata}}, \code{\link{note-summaries}},
\code{\link{note-coerce}}, \code{\link{valid-notes}}
}
