% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq_ratio}
\alias{freq_ratio}
\title{Frequency ratios}
\usage{
freq_ratio(x, ...)
}
\arguments{
\item{x}{noteworthy or music object, or a numeric vector or list of numeric
vectors for frequencies.}

\item{...}{additional arguments: \code{ratios}, which is one of \code{"all"}
(default), \code{"root"}, or \code{"range"} for filtering results. For
frequency input, you may also specify \code{octaves} and \code{accidentals}.
See details and examples.}
}
\value{
a tibble data frame
}
\description{
Obtain frequency ratios data frame.
}
\details{
This generic function returns a data frame of frequency ratios from
a vector or list of frequencies, a noteworthy object, or a music object. For
frequency inputs, a list can be used to represent multiple timesteps.
Octave numbering and accidentals are inferred from noteworthy and music
objects, but can be specified for frequency. See examples.

By default ratios are returned for all combinations of intervals in each
chord (\code{ratios = "all"}). \code{ratios = "root"} filters the result to only
include chord ratios with respect to the root note of each chord.
\code{ratios = "range"} filters to only the chord ratio between the root and
highest note.
}
\examples{
x <- as_music("c4 e_ g ce_g")
(fr <- freq_ratio(x))

x <- music_notes(x)
identical(fr, freq_ratio(x))

x <- chord_freq(x)
identical(fr, freq_ratio(x))

freq_ratio(x, accidentals = "sharp")

freq_ratio(x, ratios = "root")

freq_ratio(x, ratios = "range")
}
