% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_boone}
\alias{index_boone}
\alias{index_boone-method}
\alias{index_boone,matrix-method}
\title{Boone Heterogeneity Measure}
\usage{
index_boone(x, ...)

\S4method{index_boone}{matrix}(x, j = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} of count data
(absolute frequencies, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{j}{An \code{\link{integer}} giving the index of the reference type/taxa.
If \code{NULL} (the default), the most frequent type/taxa in any assemblage will
be used.}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Boone Heterogeneity Measure
}
\references{
Boone, J. L. (1987). Defining and Measuring Midden Catchment. \emph{American
Antiquity}, 52(2), 336-45. \doi{10.2307/281785}.

Kintigh, K. W. (1989). Sample Size, Significance, and Measures of
Diversity. In Leonard, R. D. and Jones, G. T., \emph{Quantifying Diversity
in Archaeology}. New Directions in Archaeology. Cambridge:
Cambridge University Press, p. 25-36.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
