% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_berger}
\alias{index_berger}
\alias{index_berger-method}
\alias{index_berger,numeric-method}
\title{Berger-Parker Dominance Index}
\usage{
index_berger(x, ...)

\S4method{index_berger}{numeric}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Berger-Parker Dominance Index
}
\details{
The Berger-Parker index expresses the proportional importance of the most
abundant type. This metric is highly biased by sample size and richness,
moreover it does not make use of all the information available from sample.

This is a \emph{dominance} index, so that an increase in the value of the index
accompanies a decrease in diversity.
}
\references{
Berger, W. H. & Parker, F. L. (1970). Diversity of Planktonic Foraminifera
in Deep-Sea Sediments. \emph{Science}, 168(3937), 1345-1347.
\doi{10.1126/science.168.3937.1345}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()},
\code{\link{observed}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
