% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity.R
\docType{methods}
\name{heterogeneity}
\alias{heterogeneity}
\alias{heterogeneity-method}
\alias{evenness}
\alias{evenness-method}
\alias{heterogeneity,matrix-method}
\alias{heterogeneity,data.frame-method}
\alias{evenness,matrix-method}
\alias{evenness,data.frame-method}
\title{Heterogeneity and Evenness}
\usage{
heterogeneity(object, ...)

evenness(object, ...)

\S4method{heterogeneity}{matrix}(
  object,
  ...,
  method = c("berger", "boone", "brillouin", "mcintosh", "shannon", "simpson")
)

\S4method{heterogeneity}{data.frame}(
  object,
  ...,
  method = c("berger", "boone", "brillouin", "mcintosh", "shannon", "simpson")
)

\S4method{evenness}{matrix}(
  object,
  ...,
  method = c("shannon", "brillouin", "mcintosh", "simpson")
)

\S4method{evenness}{data.frame}(
  object,
  ...,
  method = c("shannon", "brillouin", "mcintosh", "simpson")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods (see below).}

\item{method}{A \code{\link{character}} string specifying the index to be computed
(see details). Any unambiguous substring can be given.}

\item{evenness}{A \code{\link{logical}} scalar: should an evenness measure be computed
instead of an heterogeneity/dominance index?}
}
\value{
\itemize{
\item \code{heterogeneity()} returns an \linkS4class{HeterogeneityIndex} object.
\item \code{evenness()} returns an \linkS4class{EvennessIndex} object.
}
}
\description{
\itemize{
\item \code{heterogeneity()} computes an heterogeneity or dominance index.
\item \code{evenness()} computes an evenness measure.
}
}
\details{
\emph{Diversity} measurement assumes that all individuals in a specific
taxa are equivalent and that all types are equally different from each
other (Peet 1974). A measure of diversity can be achieved by using indices
built on the relative abundance of taxa. These indices (sometimes referred
to as non-parametric indices) benefit from not making assumptions about the
underlying distribution of taxa abundance: they only take relative
abundances of the species that are present and species richness into
account. Peet (1974) refers to them as indices of \emph{heterogeneity}.

Diversity indices focus on one aspect of the taxa abundance and emphasize
either \emph{\link[=richness]{richness}} (weighting towards uncommon taxa) or
\emph{dominance} (weighting towards abundant taxa; Magurran 1988).

\emph{Evenness} is a measure of how evenly individuals are distributed across the
sample.
}
\section{Heterogeneity and Evenness Measures}{

The following heterogeneity index and corresponding evenness measures
are available (see Magurran 1988 for details):
\describe{
\item{\code{berger}}{\link[=index_berger]{Berger-Parker dominance index}.}
\item{\code{boone}}{\link[=index_boone]{Boone heterogeneity measure}.}
\item{\code{brillouin}}{\link[=index_brillouin]{Brillouin diversity index}.}
\item{\code{mcintosh}}{\link[=index_mcintosh]{McIntosh dominance index}.}
\item{\code{shannon}}{\link[=index_shannon]{Shannon-Wiener diversity index}.}
\item{\code{simpson}}{\link[=index_simpson]{Simpson dominance index}.}
}

The \code{berger}, \code{mcintosh} and \code{simpson} methods return a \emph{dominance} index,
not the reciprocal or inverse form usually adopted, so that an increase in
the value of the index accompanies a decrease in diversity.
}

\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Shannon diversity index
(h <- heterogeneity(cantabria, method = "shannon"))
(e <- evenness(cantabria, method = "shannon"))

plot(h)
as.data.frame(h)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}.

Peet, R. K. (1974). The Measurement of Species Diversity. \emph{Annual Review of
Ecology and Systematics}, 5(1), 285-307.
\doi{10.1146/annurev.es.05.110174.001441}.
}
\seealso{
\code{\link[=index_berger]{index_berger()}}, \code{\link[=index_boone]{index_boone()}}, \code{\link[=index_brillouin]{index_brillouin()}},
\code{\link[=index_mcintosh]{index_mcintosh()}}, \code{\link[=index_shannon]{index_shannon()}}, \code{\link[=index_simpson]{index_simpson()}}

Other diversity measures: 
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{plot_rarefaction}},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
