% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_beta.R
\docType{methods}
\name{index_whittaker}
\alias{index_whittaker}
\alias{index_whittaker-method}
\alias{index_whittaker,matrix-method}
\title{Whittaker Measure}
\usage{
index_whittaker(x, ...)

\S4method{index_whittaker}{matrix}(x)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} of count data
(absolute frequencies, i.e. a contingency table).}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Whittaker Measure
}
\details{
This assumes that the order of the matrix rows (from \eqn{1} to \eqn{n})
follows the progression along the gradient/transect.
}
\references{
Whittaker, R. H. (1960). Vegetation of the Siskiyou Mountains, Oregon and
California. \emph{Ecological Monographs}, 30(3), 279-338.
\doi{10.2307/1943563}.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_binomial}()},
\code{\link{index_brainerd}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_morisita}()},
\code{\link{index_routledge}},
\code{\link{index_sorenson}()},
\code{\link{index_wilson}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
