/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

class Type4ShadingContext
extends GouraudShadingContext {
    private static final Log LOG = LogFactory.getLog(Type4ShadingContext.class);
    private final int bitsPerFlag;

    Type4ShadingContext(PDShadingType4 shading, ColorModel cm, AffineTransform xform, Matrix matrix, Rectangle deviceBounds) throws IOException {
        super(shading, cm, xform, matrix);
        LOG.debug("Type4ShadingContext");
        this.bitsPerFlag = shading.getBitsPerFlag();
        LOG.debug("bitsPerFlag: " + this.bitsPerFlag);
        this.setTriangleList(this.collectTriangles(shading, xform, matrix));
        this.createPixelTable(deviceBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ShadedTriangle> collectTriangles(PDShadingType4 freeTriangleShadingType, AffineTransform xform, Matrix matrix) throws IOException {
        COSDictionary dict = freeTriangleShadingType.getCOSObject();
        PDRange rangeX = freeTriangleShadingType.getDecodeForParameter(0);
        PDRange rangeY = freeTriangleShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = freeTriangleShadingType.getDecodeForParameter(2 + i);
        }
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        COSStream stream = (COSStream)dict;
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(stream.createInputStream());
        try {
            byte flag = 0;
            try {
                flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
            }
            catch (EOFException ex) {
                LOG.error(ex);
            }
            boolean eof = false;
            while (!eof) {
                try {
                    switch (flag) {
                        case 0: {
                            Vertex p0 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                            if (flag != 0) {
                                LOG.error("bad triangle: " + flag);
                            }
                            Vertex p1 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            mciis.readBits(this.bitsPerFlag);
                            if (flag != 0) {
                                LOG.error("bad triangle: " + flag);
                            }
                            Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            Point2D[] ps = new Point2D[]{p0.point, p1.point, p2.point};
                            float[][] cs = new float[][]{p0.color, p1.color, p2.color};
                            list.add(new ShadedTriangle(ps, cs));
                            flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                            break;
                        }
                        case 1: 
                        case 2: {
                            int lastIndex = list.size() - 1;
                            if (lastIndex < 0) {
                                LOG.error("broken data stream: " + list.size());
                                break;
                            }
                            ShadedTriangle preTri = (ShadedTriangle)list.get(lastIndex);
                            Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                            Point2D[] ps = new Point2D[]{flag == 1 ? preTri.corner[1] : preTri.corner[0], preTri.corner[2], p2.point};
                            float[][] cs = new float[][]{flag == 1 ? preTri.color[1] : preTri.color[0], preTri.color[2], p2.color};
                            list.add(new ShadedTriangle(ps, cs));
                            flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                            break;
                        }
                        default: {
                            LOG.warn("bad flag: " + flag);
                            break;
                        }
                    }
                }
                catch (EOFException ex) {
                    eof = true;
                }
            }
        }
        finally {
            mciis.close();
        }
        return list;
    }
}

