% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_pairwise_games_howell.R
\name{tadaa_pairwise_gh}
\alias{tadaa_pairwise_gh}
\title{Games Howell Post-Hoc Test}
\source{
\url{https://gist.github.com/aschleg/ea7942efc6108aedfa9ec98aeb6c2096}
}
\usage{
tadaa_pairwise_gh(data, response, group1, group2 = NULL, print = "df")
}
\arguments{
\item{data}{A \code{data.frame} containing the variables.}

\item{response}{The response variable, i.e. the dependent numeric vector.}

\item{group1}{The grouping variables, typically a \code{factor}.}

\item{group2}{(Optional) second grouping variable.}

\item{print}{Print method, defaults to \code{df} for \code{data.frame} output, otherwise
passed to \link[pixiedust]{sprinkle_print_method}.}
}
\value{
A \code{data.frame} or \link[pixiedust]{dust} object depending on \code{print}.
}
\description{
An implementation of the Games Howell procedure for pairwise comparisons.
The workhorse of this function is adapted from this gist:
\url{https://gist.github.com/aschleg/ea7942efc6108aedfa9ec98aeb6c2096}
}
\note{
This function is really, really slow for large comparisons (\code{k > 50}).
Sorry about that.
}
\examples{
tadaa_pairwise_gh(ngo, deutsch, jahrgang)
tadaa_pairwise_gh(ngo, deutsch, jahrgang, geschl)
}
\references{
\url{https://rpubs.com/aaronsc32/games-howell-test}
}
\seealso{
\code{\link{tadaa_pairwise_t}}, \code{\link{tadaa_pairwise_tukey}}

Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_chisq}}, \code{\link{tadaa_kruskal}},
  \code{\link{tadaa_levene}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
\author{
\code{gitub.com/aschleg}, Lukas Burk
}
