% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_plots.R
\name{tadaa_int}
\alias{tadaa_int}
\title{Interaction plots}
\usage{
tadaa_int(data, response, group1, group2, grid = FALSE,
  brewer_palette = "Set1", labels = c("A", "B"), show_n = FALSE,
  print = TRUE)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{response}{Response variable.}

\item{group1}{First grouping variable.}

\item{group2}{Second grouping variable.}

\item{grid}{If \code{TRUE}, the resulting graphs will be arranged in a grid
via \link[cowplot:plot_grid]{cowplot::plot_grid}.}

\item{brewer_palette}{The name of the \code{RColorBrewer} palette to use,
defaults to \code{Set1}.}

\item{labels}{Labels used for the plots when printed in a grid (\code{grid = TRUE}),
defaults to \code{c("A", "B")}.}

\item{show_n}{If \code{TRUE}, displays N in plot subtitle.}

\item{print}{Default is \code{TRUE}, set \code{FALSE} to suppress automatic printing.
Useful if you intend to further modify the outpur plots.}
}
\value{
Invisible: A list with two ggplot2 objects named \code{p1} and \code{p2}.
If \code{print = TRUE}: Printed: The one or two ggplot2 objects, depending on \code{grid}.
}
\description{
Easily generate interaction plots of two nominal grouping
variables and a numeric response variable.
}
\examples{
\dontrun{
tadaa_int(ngo, stunzahl, jahrgang, geschl)

# As grid, if cowplot is installed
tadaa_int(ngo, stunzahl, jahrgang, geschl, grid = TRUE)
}
}
\seealso{
Other Tadaa-plot functions: \code{\link{tadaa_balance}},
  \code{\link{tadaa_mean_ci}},
  \code{\link{tadaa_plot_tukey}}
}
