% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tanaka_contour.R
\name{tanaka_contour}
\alias{tanaka_contour}
\title{Create a Contour Layer}
\usage{
tanaka_contour(x, nclass = 8, breaks, mask)
}
\arguments{
\item{x}{a raster object.}

\item{nclass}{a number of class.}

\item{breaks}{a vector of break values.}

\item{mask}{a mask layer, a POLYGON or MULTIPOLYGON sf object.}
}
\value{
A MULTIPOLYGON sf object is return. The data.frame contains 3 fields:
id, min (minimum value of the raster in the MULTIPOLYGON) and max (maximum
value of the raster in the MULTIPOLYGON).
}
\description{
Create a contour layer.
}
\examples{
library(tanaka)
library(terra)
library(sf)
ras <- rast(system.file("tif/elev.tif", package = "tanaka"))
iso <- tanaka_contour(x = ras)
plot(st_geometry(iso), col = c(
  "#FBDEE1", "#F0BFC3", "#E7A1A6",
  "#DD8287", "#D05A60", "#C03239",
  "#721B20", "#1D0809"
))
}
