% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto_rep.R
\name{tar_quarto_rep}
\alias{tar_quarto_rep}
\title{Parameterized Quarto with dynamic branching.}
\usage{
tar_quarto_rep(
  name,
  path,
  execute_params = data.frame(),
  batches = NULL,
  extra_files = character(0),
  execute = TRUE,
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  pandoc_args = NULL,
  rep_workers = 1,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue")
)
}
\arguments{
\item{name}{Symbol, name of the target. A target
name must be a valid name for a symbol in R, and it
must not start with a dot. Subsequent targets
can refer to this name symbolically to induce a dependency relationship:
e.g. \code{tar_target(downstream_target, f(upstream_target))} is a
target named \code{downstream_target} which depends on a target
\code{upstream_target} and a function \code{f()}. In addition, a target's
name determines its random number generator seed. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{\link[targets:tar_seed_set]{tar_seed_set()}}
on the result to locally recreate the target's initial RNG state.}

\item{path}{Character string, file path to the Quarto source file.
Must have length 1.}

\item{execute_params}{Code to generate
a data frame or \code{tibble} with one row per rendered report
and one column per Quarto parameter. You may also include an
\code{output_file} column to specify the path of each rendered report.
If included, the \code{output_file} column must be a character vector
with one and only one output file for each row of parameters.
If an \code{output_file} column is not included,
then the output files are automatically determined using the parameters,
and the default file format is determined by the YAML front-matter
of the Quarto source document. Only the first file format is used,
the others are not generated.
Quarto parameters must not be named \code{tar_group} or \code{output_file}.
This \code{execute_params} argument is converted into the command for a target
that supplies the Quarto parameters.}

\item{batches}{Number of batches. This is also the number of dynamic
branches created during \code{tar_make()}.}

\item{extra_files}{Character vector of extra files that \code{targets}
should track for changes. If the content of one of these files changes,
then the report will rerun over all the parameters on the next
\code{tar_make()}. These files are \emph{extra} files, and they
do not include the Quarto
source document or rendered output document,
which are already tracked for changes. Examples include
bibliographies, style sheets, and supporting image files.}

\item{execute}{Whether to execute embedded code chunks.}

\item{cache}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}

\item{cache_refresh}{Force refresh of execution cache.}

\item{debug}{Leave intermediate files in place after render.}

\item{quiet}{Suppress warning and other messages.}

\item{pandoc_args}{Additional command line options to pass to pandoc.}

\item{rep_workers}{Positive integer of length 1, number of local R
processes to use to run reps within batches in parallel. If 1,
then reps are run sequentially within each batch. If greater than 1,
then reps within batch are run in parallel using a PSOCK cluster.}

\item{tidy_eval}{Logical of length 1, whether to use tidy evaluation
to resolve \code{execute_params}. Similar to the \code{tidy_eval}
argument of \code{targets::tar_target()}.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vectors::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}. In the case of list iteration, \code{tar_read(your_target)}
will return a list of lists, where the outer list has one element per
batch and each inner list has one element per rep within batch.
To un-batch this nested list, call
\code{tar_read(your_target, recursive = FALSE)}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a data frame. The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{\link[=tar_group]{tar_group()}} function to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
this memory strategy applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get dispatched earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}
}
\value{
A list of target objects to render the Quarto
reports. Changes to the parameters, source file, dependencies, etc.
will cause the appropriate targets to rerun during \code{tar_make()}.
See the "Target objects" section for background.
}
\description{
Targets to render a parameterized Quarto document
with multiple sets of parameters.
}
\details{
\code{tar_quarto_rep()} is an alternative to \code{tar_target()} for
a parameterized Quarto document that depends on other targets.
Parameters must be given as a data frame with one row per
rendered report and one column per parameter. An optional
\code{output_file} column may be included to set the output file path
of each rendered report. (See the \code{execute_params} argument for details.)

The Quarto source should mention other dependency targets
\code{tar_load()} and \code{tar_read()} in the active code chunks
(which also allows you to render the report
outside the pipeline if the \verb{_targets/} data store already exists
and appropriate defaults are specified for the parameters).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_quarto()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the report
and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return the output
report files: the rendered document, the source file,
and file paths mentioned in \code{files}. All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{quarto::quarto_render()}.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\section{Replicate-specific seeds}{

In ordinary pipelines, each target has its own unique deterministic
pseudo-random number generator seed derived from its target name.
In batched replicate, however, each batch is a target with multiple
replicate within that batch. That is why \code{\link[=tar_rep]{tar_rep()}}
and friends give each \emph{replicate} its own unique seed.
Each replicate-specific seed is created
based on the dynamic parent target name,
\code{tar_option_get("seed")} (for \code{targets} version 0.13.5.9000 and above),
batch index, and rep-within-batch index.
The seed is set just before the replicate runs.
Replicate-specific seeds are invariant to batching structure.
In other words,
\code{tar_rep(name = x, command = rnorm(1), batches = 100, reps = 1, ...)}
produces the same numerical output as
\code{tar_rep(name = x, command = rnorm(1), batches = 10, reps = 10, ...)}
(but with different batch names).
Other target factories with this seed scheme are \code{\link[=tar_rep2]{tar_rep2()}},
\code{\link[=tar_map_rep]{tar_map_rep()}}, \code{\link[=tar_map2_count]{tar_map2_count()}}, \code{\link[=tar_map2_size]{tar_map2_size()}},
and \code{\link[=tar_render_rep]{tar_render_rep()}}.
For the \verb{tar_map2_*()} functions,
it is possible to manually supply your own seeds
through the \code{command1} argument and then invoke them in your
custom code for \code{command2} (\code{set.seed()}, \code{withr::with_seed},
or \code{withr::local_seed()}). For \code{\link[=tar_render_rep]{tar_render_rep()}},
custom seeds can be supplied to the \code{params} argument
and then invoked in the individual R Markdown reports.
Likewise with \code{\link[=tar_quarto_rep]{tar_quarto_rep()}} and the \code{execute_params} argument.
}

\section{Literate programming limitations}{

Literate programming files are messy and variable,
so functions like \code{\link[=tar_render]{tar_render()}} have limitations:
* Child documents are not tracked for changes.
* Upstream target dependencies are not detected if \code{\link[=tar_read]{tar_read()}}
and/or \code{\link[=tar_load]{tar_load()}} are called from a user-defined function.
In addition, single target names must be mentioned and they must
be symbols. \code{tar_load("x")} and \code{tar_load(contains("x"))} may not
detect target \code{x}.
* Special/optional input/output files may not be detected in all cases.
* \code{\link[=tar_render]{tar_render()}} and friends are for local files only. They do not
integrate with the cloud storage capabilities of \code{targets}.
}

\section{Quarto troubleshooting}{

If you encounter difficult errors, please read
\url{https://github.com/quarto-dev/quarto-r/issues/16}.
In addition, please try to reproduce the error using
\code{quarto::quarto_render("your_report.qmd", execute_dir = getwd())}
without using \code{targets} at all. Isolating errors this way
makes them much easier to solve.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
# Parameterized Quarto:
lines <- c(
  "---",
  "title: 'report.qmd file'",
  "output_format: html_document",
  "params:",
  "  par: \"default value\"",
  "---",
  "Assume these lines are in a file called report.qmd.",
  "```{r}",
  "print(params$par)",
  "```"
)
writeLines(lines, "report.qmd") # In tar_dir(), not the user's file space.
# The following pipeline will run the report for each row of params.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_quarto_rep(
      report,
      path = "report.qmd",
      execute_params = tibble::tibble(par = c(1, 2))
    )
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.
})
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit}()},
\code{\link{tar_knit_raw}()},
\code{\link{tar_quarto}()},
\code{\link{tar_quarto_raw}()},
\code{\link{tar_quarto_rep_raw}()},
\code{\link{tar_render}()},
\code{\link{tar_render_raw}()},
\code{\link{tar_render_rep}()},
\code{\link{tar_render_rep_raw}()}
}
\concept{Literate programming targets}
