% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_read.R
\name{tar_read}
\alias{tar_read}
\title{Read a target's value from storage.}
\usage{
tar_read(name, branches = NULL, meta = tar_meta())
}
\arguments{
\item{name}{Symbol, name of the target to read.}

\item{branches}{Integer of indices of the branches to load
if the target is a pattern.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}
}
\value{
The target's return value from its file in
\verb{_targets/objects/}, or the paths to the custom files and directories
if \code{format = "file"} was set.
}
\description{
Read a target's return value from its file in
\verb{_targets/objects/}. For dynamic files (i.e. \code{format = "file"})
the paths are returned.
}
\examples{
tar_dir({ # Write all files to a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_make()
tar_read(x)
})
}
