% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_engine_knitr.R
\name{tar_engine_knitr}
\alias{tar_engine_knitr}
\title{Target Markdown \code{knitr} engine}
\usage{
tar_engine_knitr(options)
}
\arguments{
\item{options}{A named list of \code{knitr} chunk options.}
}
\value{
Character, output generated from \code{knitr::engine_output()}.
}
\description{
\code{knitr} language engine that runs \code{{targets}}
code chunks in Target Markdown.
}
\section{Target Markdown interactive mode}{

Target Markdown has two modes:
\enumerate{
\item Non-interactive mode. This is the default when you
run \code{knitr::knit()} or \code{rmarkdown::render()}.
Here, the code in \code{{targets}} code chunks gets written
to special script files in order to set up a \code{targets}
pipeline to run later.
\item Interactive mode: here, no scripts are written to set up
a pipeline. Rather, the globals or targets in question
are run in the current environment and the values
are assigned to that environment.
}

The mode is interactive if \code{!isTRUE(getOption("knitr.in.progress"))},
is \code{TRUE}. The \code{knitr.in.progress} option is \code{TRUE}
when you run \code{knitr::knit()} or \code{rmarkdown::render()}
and \code{NULL} if you are running one chunk at a time interactively
in an integrated development environment, e.g. the
notebook interface in RStudio:
\url{https://bookdown.org/yihui/rmarkdown/notebook.html}.
You can choose the mode with the \code{tar_interactive}
chunk option.
(In \code{targets} 0.6.0, \code{tar_interactive} defaults to \code{interactive()}
instead of \code{!isTRUE(getOption("knitr.in.progress"))}.)
}

\section{Target Markdown chunk options}{

Target Markdown introduces the following \code{knitr} code chunk options.
Most other standard \code{knitr} code chunk options should just work
in non-interactive mode. In interactive mode, not all
\itemize{
\item \code{tar_globals}: Logical of length 1,
whether to define globals or targets.
If \code{TRUE}, the chunk code defines functions, objects, and options
common to all the targets. If \code{FALSE} or \code{NULL} (default),
then the chunk returns formal targets for the pipeline.
\item \code{tar_interactive}: Logical of length 1, whether to run in
interactive mode or non-interactive mode.
See the "Target Markdown interactive mode" section of this
help file for details.
\item \code{tar_name}: name to use for writing helper script files
(e.g. \verb{_targets_r/targets/target_script.R})
and specifying target names if the \code{tar_simple} chunk option
is \code{TRUE}. All helper scripts and target names must have
unique names, so please do not set this option globally
with \code{knitr::opts_chunk$set()}.
\item \code{tar_script}: Character of length 1, where to write the
target script file in non-interactive mode. Most users can
skip this option and stick with the default \verb{_targets.R} script path.
Helper script files are always written next to the target script in
a folder with an \code{"_r"} suffix. The \code{tar_script} path must either be
absolute or be relative to the project root
(where you call \code{tar_make()} or similar).
If not specified, the target script path defaults to
\code{tar_config_get("script")} (default: \verb{_targets.R};
helpers default: \verb{_targets_r/}). When you run \code{tar_make()} etc.
with a non-default target script, you must select the correct target
script file either with the \code{script} argument or with
\code{tar_config_set(script = ...)}. The function will \code{source()}
the script file from the current working directory
(i.e. with \code{chdir = FALSE} in \code{source()}).
\item \code{tar_simple}: Logical of length 1.
Set to \code{TRUE} to define a single target with a simplified interface.
In code chunks with \code{tar_simple} equal to \code{TRUE}, the chunk label
(or the \code{tar_name} chunk option if you set it)
becomes the name, and the chunk code becomes the command.
In other words, a code chunk with label \code{targetname} and
command \code{mycommand()} automatically gets converted to
\code{tar_target(name = targetname, command = mycommand())}.
All other arguments of \code{tar_target()} remain at their default
values (configurable with \code{tar_option_set()} in a
\code{tar_globals = TRUE} chunk).
}
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
# Register the engine.
if (requireNamespace("knitr", quietly = TRUE)) {
  knitr::knit_engines$set(targets = targets::tar_engine_knitr)
}
# Then, {targets} code chunks in a knitr report will run
# as described at
# <https://books.ropensci.org/targets/literate-programming.html>.
}
}
\seealso{
\url{https://books.ropensci.org/targets/literate-programming.html}

Other Target Markdown: 
\code{\link{tar_interactive}()},
\code{\link{tar_noninteractive}()},
\code{\link{tar_toggle}()}
}
\concept{Target Markdown}
