tar_test("tar_renv() works", {
  expect_false(file.exists("_targets_packages.R"))
  tar_script({
    tar_option_set(packages = c("tibble", "qs2"))
    list()
  })
  tar_renv()
  pkgs <- sort(c("tibble", "qs2", eval(formals(tar_renv)$extras)))
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
  expect_equal(
    readLines("_targets_packages.R")[1],
    "# Generated by targets::tar_renv(): do not edit by hand"
  )
})

tar_test("tar_renv() works with custom path", {
  path <- tempfile()
  expect_false(file.exists(path))
  tar_script({
    tar_option_set(packages = c("tibble", "qs2"))
    list()
  })
  tar_renv(path = path, callr_function = NULL)
  pkgs <- sort(c("tibble", "qs2", eval(formals(tar_renv)$extras)))
  expect_true(file.exists(path))
  expect_equal(
    sort(readLines(path)),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_renv() packages set in tar_target()", {
  tar_script({
    tar_option_set(packages = character())
    list(
      tar_target(x, "foo", packages = "tibble")
    )
  })
  tar_renv(callr_function = NULL)
  pkgs <- sort(c("tibble", eval(formals(tar_renv)$extras)))
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_renv() formats set in tar_target()", {
  tar_script({
    tar_option_set(packages = character())
    list(
      tar_target(x, "foo", format = "qs")
    )
  })
  tar_renv(callr_function = NULL)
  pkgs <- sort(c("qs2", eval(formals(tar_renv)$extras)))
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_renv() formats set in pattern targets", {
  tar_script({
    tar_option_set(packages = character())
    list(
      tar_target(y, "foo", packages = character(0)),
      tar_target(x, y, format = "qs", pattern = map(y))
    )
  })
  tar_renv(callr_function = NULL)
  pkgs <- sort(c("qs2", eval(formals(tar_renv)$extras)))
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_renv() packages set in tar_option_set()", {
  tar_script({
    tar_option_set(
      packages = "tibble",
      format = "qs"
    )
    list()
  })
  tar_renv(callr_function = NULL)
  pkgs <- sort(c("tibble", "qs2", eval(formals(tar_renv)$extras)))
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_renv() non-default extra packages", {
  tar_script({
    tar_option_set(packages = character())
    list()
  })
  tar_renv(extras = "tibble", callr_function = NULL)
  pkgs <- "tibble"
  expect_true(file.exists("_targets_packages.R"))
  expect_equal(
    sort(readLines("_targets_packages.R")),
    sort(
      c(
        "# Generated by targets::tar_renv(): do not edit by hand",
        paste0("library(", pkgs, ")")
      )
    )
  )
})

tar_test("tar_env() cannot go inside _targets.R", {
  tar_script({
    tar_renv()
    list(tar_target(x, 1))
  })
  expect_error(
    tar_validate(callr_function = NULL),
    class = "tar_condition_validate"
  )
})

tar_test("custom script and store args", {
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  tar_script(tar_target(x, "y", format = "qs"), script = "example/script.R")
  tar_renv(script = "example/script.R", callr_function = NULL)
  expect_true(file.exists("_targets_packages.R"))
  lines <- readLines("_targets_packages.R")
  expect_true(any(grepl("qs2", lines)))
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
  expect_true(file.exists("example/script.R"))
  expect_false(file.exists("example/store"))
  tar_config_set(script = "x")
  expect_equal(tar_config_get("script"), "x")
  expect_true(file.exists("_targets.yaml"))
})

tar_test("custom script and store args with callr function", {
  skip_cran()
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  tar_script(tar_target(x, "y", format = "qs"), script = "example/script.R")
  tar_renv(script = "example/script.R")
  expect_true(file.exists("_targets_packages.R"))
  lines <- readLines("_targets_packages.R")
  expect_true(any(grepl("qs2", lines)))
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
  expect_true(file.exists("example/script.R"))
  expect_false(file.exists("example/store"))
  tar_config_set(script = "x")
  expect_equal(tar_config_get("script"), "x")
  expect_true(file.exists("_targets.yaml"))
})
