% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load_raw.R
\name{tar_load_raw}
\alias{tar_load_raw}
\title{Load the values of targets (raw version).}
\usage{
tar_load_raw(
  names,
  branches = NULL,
  meta = tar_meta(store = store),
  strict = TRUE,
  silent = FALSE,
  envir = parent.frame(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Character vector, names of the targets to load.
Names are expected to appear in the metadata in \verb{_targets/meta}.
Any target names not in the metadata are ignored.}

\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{strict}{Logical of length 1, whether to error out
if one of the selected targets is in the metadata
but cannot be loaded.
Set to \code{FALSE} to just load the targets in the metadata
that can be loaded and skip the others.}

\item{silent}{Logical of length 1. Only relevant when
\code{strict} is \code{FALSE}. If \code{silent} is \code{FALSE}
and \code{strict} is \code{FALSE}, then a message will be printed
if a target is in the metadata but cannot be loaded.
However, load failures
will not stop other targets from being loaded.}

\item{envir}{Environment to put the loaded targets.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Nothing.
}
\description{
Same as \code{\link[=tar_load]{tar_load()}} except \code{names} is a character vector.
Do not use in \code{knitr} or R Markdown reports with \code{tarchetypes::tar_knit()}
or \code{tarchetypes::tar_render()}.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.


Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
tar_load_raw(any_of(c("y1", "y2")))
y1
y2
})
}
}
\seealso{
Other data: 
\code{\link{tar_crew}()},
\code{\link{tar_load_everything}()},
\code{\link{tar_load}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
