% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_watch_ui.R
\name{tar_watch_ui}
\alias{tar_watch_ui}
\title{Shiny module UI for tar_watch()}
\usage{
tar_watch_ui(
  id,
  label = "tar_watch_label",
  seconds = 10,
  seconds_min = 1,
  seconds_max = 60,
  seconds_step = 1,
  targets_only = FALSE,
  outdated = FALSE,
  label_tar_visnetwork = NULL,
  level_separation = 150,
  degree_from = 1L,
  degree_to = 1L,
  height = "650px",
  display = "summary",
  displays = c("summary", "branches", "progress", "graph", "about")
)
}
\arguments{
\item{id}{Character of length 1, ID corresponding to the UI function
of the module.}

\item{label}{Label for the module.}

\item{seconds}{Numeric of length 1,
default number of seconds between refreshes of the graph.
Can be changed in the app controls.}

\item{seconds_min}{Numeric of length 1, lower bound of \code{seconds}
in the app controls.}

\item{seconds_max}{Numeric of length 1, upper bound of \code{seconds}
in the app controls.}

\item{seconds_step}{Numeric of length 1, step size of \code{seconds}
in the app controls.}

\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include global functions and objects.}

\item{outdated}{Logical, whether to show colors to distinguish outdated
targets from up-to-date targets. (Global functions and objects
still show these colors.) Looking for outdated targets
takes a lot of time for large pipelines with lots of branches,
and setting \code{outdated} to \code{FALSE} is a nice way to speed up the graph
if you only want to see dependency relationships and pipeline progress.}

\item{label_tar_visnetwork}{Character vector, \code{label} argument to
\code{\link[=tar_visnetwork]{tar_visnetwork()}}.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to \code{150}.}

\item{degree_from}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_from}
controls the number of edges the neighborhood extends upstream.}

\item{degree_to}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_to}
controls the number of edges the neighborhood extends downstream.}

\item{height}{Character of length 1,
height of the \code{visNetwork} widget and branches table.}

\item{display}{Character of length 1, which display to show first.}

\item{displays}{Character vector of choices for the display.
Elements can be any of
\code{"graph"}, \code{"summary"}, \code{"branches"}, or \code{"about"}.}
}
\value{
A Shiny module UI.
}
\description{
Use \code{tar_watch_ui()} and \code{\link[=tar_watch_server]{tar_watch_server()}}
to include \code{\link[=tar_watch]{tar_watch()}} as a Shiny module in an app.
}
\seealso{
Other progress: 
\code{\link{tar_canceled}()},
\code{\link{tar_completed}()},
\code{\link{tar_dispatched}()},
\code{\link{tar_errored}()},
\code{\link{tar_poll}()},
\code{\link{tar_progress}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_skipped}()},
\code{\link{tar_watch}()},
\code{\link{tar_watch_server}()}
}
\concept{progress}
