% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_common.R
\name{filter_common}
\alias{filter_common}
\title{Look up taxonomic information by common name}
\usage{
filter_common(
  name,
  provider = getOption("taxadb_default_provider", "itis"),
  version = latest_version(),
  collect = TRUE,
  ignore_case = TRUE,
  db = td_connect()
)
}
\arguments{
\item{name}{a character vector of common (vernacular English) names,
e.g. "Humans"}

\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{tl_import} for details.}

\item{collect}{logical, default \code{TRUE}. Should we return an in-memory
data.frame (default, usually the most convenient), or a reference to
lazy-eval table on disk (useful for very large tables on which we may
first perform subsequent filtering operations.)}

\item{ignore_case}{should we ignore case (capitalization) in matching names?
default is \code{TRUE}.}

\item{db}{a connection to the taxadb database. See details.}
}
\value{
a data.frame in the Darwin Core tabular format containing the
matching taxonomic entities.
}
\description{
Look up taxonomic information by common name
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   options("taxadb_default_provider"="itis_test")
   Sys.setenv(TAXADB_HOME=tempdir())
  }

filter_common("Pied Tamarin")

}

  \dontshow{
   ## All examples use a temporary directory
   Sys.unsetenv("TAXADB_HOME")
   options("taxadb_default_provider" = NULL)
  }
}
\seealso{
Other filter_by: 
\code{\link{filter_by}()},
\code{\link{filter_id}()},
\code{\link{filter_name}()},
\code{\link{filter_rank}()}
}
\concept{filter_by}
