% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_state.R
\name{taxon-state}
\alias{taxon-state}
\alias{taxon_last}
\alias{taxon_clear}
\title{Last taxon state object from a \code{get_*} function call}
\usage{
taxon_last()

taxon_clear()
}
\value{
\code{taxon_last()} returns an object of class \code{taxon_state}, the last
one used, else \code{NULL} if none found. \code{taxon_clear()} clears the saved state
}
\description{
Last taxon state object from a \code{get_*} function call
}
\details{
\itemize{
\item \code{taxon_last()}: get the last \code{taxon_state} object in use
\item \code{taxon_clear()}: clear any data from last \code{taxon_state} object
}

The \code{taxon_state} object is an R6 object that holds data and methods
used for keeping track of results gathered within a \code{get_*} function.
You shouldn't create \code{taxon_state} R6 objects yourself.

Behaviors to be aware of:
\itemize{
\item If a \code{taxon_state} object is not passed you don't need to worry about
a previously run \code{get_*} function interfering with another \code{get_*}
function call - you have to explicitly pass a \code{taxon_state} object
to use \code{taxon_state}
\item The passed in \code{taxon_state} object must have a \code{$class} matching that of
the \code{get_*} function being called. For example, you can only pass a
\code{taxon_state} with \code{$class} of \code{gbifid} to \code{get_gbifid()}, and so on.
\item If you run \code{taxon_clear()} while a \code{get*} function is running, you may
lose track of any state known to this package before it was cleared
}

See the internal method \link{progressor} for information on how we control messages
in \code{get*} functions
}
\examples{
spp <- names_list("species", 3)
res <- get_gbifid(spp)
z <- taxon_last()
z
z$taxa_remaining()
z$taxa_completed()
z$count # active binding; no parens needed

# cleanup
taxon_clear()
}
