% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R
\name{match_names}
\alias{match_names}
\alias{match_names,character,character-method}
\alias{match_names,character,taxlist-method}
\title{Search matchings between character and taxlist objects}
\usage{
match_names(x, object, ...)

\S4method{match_names}{character,character}(x, object, best = 5, clean = TRUE, decreasing = TRUE, ...)

\S4method{match_names}{character,taxlist}(
  x,
  object,
  clean = TRUE,
  output = "data.frame",
  best = 5,
  show_concepts = FALSE,
  accepted_only = FALSE,
  method = "lcs",
  sort_by,
  order_args = list(),
  ...
)
}
\arguments{
\item{x}{A character vector with names to be compared.}

\item{object}{An object of class \linkS4class{taxlist} to be compared
with.}

\item{best}{Integer value indicating how many from the best matches have to
be displayed (only working for \code{output="list"}).}

\item{clean}{Logical value, whether leading, tailing and double blanks should
be deleted from \code{x}.}

\item{decreasing}{Logical value indicating whether retrieved names should be
sorted by decreasing or increasing similarity value. In the character
method, the sorting corresponds to similarities between the queried value
and the reference vector (argument \code{object}). In the taxlist method using
\verb{'output = "data.frame'"}, the order corresponds to the similarity of the
best match (by default, no sorting is done). This argument is passed to
\code{\link[=order]{order()}}.}

\item{output}{Character value indicating the type of output. Alternative
values are "list" (taxon concepts ID's sorted by similarity for each
queried name) or "data.frame" (a table including the best match for every
queried name).}

\item{show_concepts}{Logical value, whether respective concepts should be
displayed in output or not.}

\item{accepted_only}{Logical value, whether only accepted names should be
matched or all usage names (including synonyms).}

\item{method, ...}{Further arguments passed to \code{\link[=stringsim]{stringsim()}}.}

\item{sort_by}{A character vector including the output columns used for
sorting the output table. Used only in 'character,taxlist-method'. The
function checks the presence of these values as columns in the output
data frame.}

\item{order_args}{A named list including arguments passed to \code{\link[=order]{order()}} in the
'character,taxlist-method'.}
}
\description{
Names provided in a character vector will be compared with names stored in
slot \code{taxonNames} within an object of class \linkS4class{taxlist} by
using the function \code{\link[=stringsim]{stringsim()}}.
}
\examples{
## Names to be compared
species <- c("Cperus papyrus", "Typha australis", "Luke skywalker")

## Comparing character vectors
match_names("Cyperus paper", species)

## Retrieve taxon usage names
match_names(species, Easplist)

## Display accepted names in output
match_names(x = species, object = Easplist, show_concepts = TRUE)
}
\seealso{
\code{\link[=stringsim]{stringsim()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
