% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_scientificname.R
\name{melt_scientificname}
\alias{melt_scientificname}
\title{Melt scientific name into fields}
\usage{
melt_scientificname(
  dat,
  sciname = "",
  genus = "genus",
  subgenus = "subgenus",
  species = "species",
  subspecies = "subspecies",
  author = "author",
  verbose = FALSE
)
}
\arguments{
\item{dat}{data frame containing scientific names}

\item{sciname}{column name for scientific names, Default: ''}

\item{genus}{column name for genus, Default: 'genus'}

\item{subgenus}{column name for subgenus, Default: 'subgenus'}

\item{species}{column name for species, Default: 'species'}

\item{subspecies}{column name for subspecies, Default: 'subspecies'}

\item{author}{column name for author, Default: 'author'}

\item{verbose}{verbose output, Default: FALSE}
}
\value{
data frame with additional columns for fields
}
\description{
Try to parse scientific names into Genus, species, Subspecies,
 Author etc.
}
\details{
Helpful function to break down Scientific names into Genus,
species, Subspecies, Author so that the names can be constructed into canonical
 names for matching
}
\examples{
\dontrun{
if(interactive()){
 melt_scientificname(mylist, sciname="Scientific", genus="genus",
  subgenus="subgenus", species="species",subspecies="subspecies",
  author="author")
 }
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()}
}
\concept{Name functions}
