% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slice.R
\name{teal_slice}
\alias{teal_slice}
\alias{is.teal_slice}
\alias{as.teal_slice}
\alias{as.list.teal_slice}
\alias{format.teal_slice}
\alias{print.teal_slice}
\title{Specify single filter}
\usage{
teal_slice(
  dataname,
  varname,
  id,
  expr,
  choices = NULL,
  selected = NULL,
  keep_na = NULL,
  keep_inf = NULL,
  fixed = FALSE,
  anchored = FALSE,
  multiple = TRUE,
  title = NULL,
  ...
)

is.teal_slice(x)

as.teal_slice(x)

\method{as.list}{teal_slice}(x, ...)

\method{format}{teal_slice}(x, show_all = FALSE, trim_lines = TRUE, ...)

\method{print}{teal_slice}(x, ...)
}
\arguments{
\item{dataname}{(\code{character(1)}) name of data set}

\item{varname}{(\code{character(1)}) name of variable}

\item{id}{(\code{character(1)}) identifier of the filter. Must be specified when \code{expr} is set.
When \code{varname} is specified then \code{id} is set to \code{"{dataname} {varname}"} by default.}

\item{expr}{(\code{character(1)}) string providing a logical expression.
Must be a valid \code{R} expression which can be evaluated in the context of the data set.
For a \code{data.frame} \code{var == "x"} is sufficient, but \code{MultiAssayExperiment::subsetByColData}
requires \code{dataname} prefix, \emph{e.g.} \code{data$var == "x"}.}

\item{choices}{(optional \code{vector}) specifying allowed choices;
When specified it should be a subset of values in variable denoted by \code{varname};
Type and size depends on variable type. Factors are coerced to character.}

\item{selected}{(optional \code{vector}) of selected values from \code{choices};
Type and size depends on variable type. Factors are coerced to character.}

\item{keep_na}{(optional \code{logical(1)}) flag specifying whether to keep missing values}

\item{keep_inf}{(optional \code{logical(1)}) flag specifying whether to keep infinite values}

\item{fixed}{(\code{logical(1)}) flag specifying whether to fix this filter state (forbid setting state)}

\item{anchored}{(\code{logical(1)}) flag specifying whether to lock this filter state (forbid removing and inactivating)}

\item{multiple}{(optional \code{logical(1)}) flag specifying whether more than one value can be selected;
only applicable to \code{ChoicesFilterState} and \code{LogicalFilterState}}

\item{title}{(optional \code{character(1)}) title of the filter. Ignored when \code{varname} is set.}

\item{...}{in \code{teal_slice} method these are additional arguments which can be handled by extensions
of \code{teal.slice} classes. In other methods these are further arguments passed to or from other methods.}

\item{x}{(\code{teal.slice})}

\item{show_all}{(\code{logical(1)}) indicating whether to show all fields. If set to \code{FALSE},
only non-NULL elements will be printed.}

\item{trim_lines}{(\code{logical(1)}) indicating whether to trim lines when printing.}
}
\value{
A \code{teal.slice} object. Depending on whether \code{varname} or \code{expr} was specified, the resulting
\code{teal_slice} also receives class \code{teal_slice_var} or \code{teal_slice_expr}, respectively.
}
\description{
Create a \code{teal_slice} object that holds complete information on filtering one variable.
}
\details{
\code{teal_slice} object fully describes filter state and can be used to create,
modify, and delete a filter state. A \code{teal_slice} contains a number of common fields
(all named arguments of \code{teal_slice}), some of which are mandatory, but only
\code{dataname} and  either \code{varname} or \code{expr} must be specified, while the others have default
values.

Setting any of the other values to \code{NULL} means that those properties will not be modified
(when setting an existing state) or that they will be determined by data (when creating new a new one).
Entire object is \code{FilterState} class member and can be accessed with \code{FilterState$get_state()}.

A \code{teal_slice} can come in two flavors:
\enumerate{
\item \code{teal_slice_var} -
this describes a typical interactive filter that refers to a single variable, managed by the \code{FilterState} class.
This class is created when \code{varname} is specified.
The object retains all fields specified in the call. \code{id} can be created by default and need not be specified.
\item \code{teal_slice_expr} -
this describes a filter state that refers to an expression, which can potentially include multiple variables,
managed by the \code{FilterStateExpr} class.
This class is created when \code{expr} is specified.
\code{dataname} and \code{anchored} are retained, \code{fixed} is set to \code{TRUE}, \code{id} becomes mandatory, \code{title}
remains optional, while other arguments are disregarded.
}

A teal_slice can be passed \code{FilterState}/\code{FilterStateExpr} constructors to instantiate an object.
It can also be passed to \code{FilterState$set_state} to modify the state.
However, once a \code{FilterState} is created, only the mutable features can be set with a teal_slice:
\code{selected}, \code{keep_na} and \code{keep_inf}.

Special consideration is given to two fields: \code{fixed} and \code{anchored}.
These are always immutable logical flags that default to \code{FALSE}.
In a \code{FilterState} instantiated with \code{fixed = TRUE} the features
\code{selected}, \code{keep_na}, \code{keep_inf} cannot be changed.
Note that a \code{FilterStateExpr} is always considered to have \code{fixed = TRUE}.
A \code{FilterState} instantiated with \code{anchored = TRUE} cannot be removed.
}
\note{
Date time objects of \code{POSIX*t} classes are printed as strings after converting to UTC timezone.
}
\section{Filters in \code{SumarizedExperiment} and \code{MultiAssayExperiment} objects}{


To establish a filter on a column in a \code{data.frame}, \code{dataname} and \code{varname} are sufficient.
\code{MultiAssayExperiment} objects can be filtered either on their \code{colData} slot (which contains subject information)
or on their experiments, which are stored in the \code{experimentList} slot.
For filters referring to \code{colData} no extra arguments are needed.
If a filter state is created for an experiment, that experiment name must be specified in the \code{experiment} argument.
Furthermore, to specify filter for an \code{SummarizedExperiment} one must also set \code{arg}
(\code{"subset"}  or \code{"select"}, arguments in the \code{\link[=subset]{subset()}} function for \code{SummarizedExperiment})
in order to determine whether the filter refers to the \code{SE}'s \code{rowData} or \code{colData}.
}

\examples{
x1 <- teal_slice(
  dataname = "data",
  id = "Female adults",
  expr = "SEX == 'F' & AGE >= 18",
  title = "Female adults"
)
x2 <- teal_slice(
  dataname = "data",
  varname = "var",
  choices = c("F", "M", "U"),
  selected = "F",
  keep_na = TRUE,
  keep_inf = TRUE,
  fixed = FALSE,
  anchored = FALSE,
  multiple = TRUE,
  id = "Gender",
  extra_arg = "extra"
)

is.teal_slice(x1)
as.list(x1)
as.teal_slice(list(dataname = "a", varname = "var"))
format(x1)
format(x1, show_all = TRUE, trim_lines = FALSE)
print(x1)
print(x1, show_all = TRUE, trim_lines = FALSE)

}
\seealso{
\code{\link{teal_slices}}
}
\keyword{internal}
