% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forwardsolve.kron.R
\name{forwardsolve.kron}
\alias{forwardsolve.kron}
\title{Solves a triangular system with a Kronecker product structure}
\usage{
forwardsolve.kron(A, B, y)
}
\arguments{
\item{A}{an \eqn{m x n} matrix}

\item{B}{an \eqn{p x q} matrix}

\item{y}{an \eqn{mp x s} matrix}
}
\value{
x
}
\description{
Solves \eqn{kron(A, B) x = y} where \eqn{A} and \eqn{B} are lower triangular
matrices.
}
\examples{
set.seed(2018)

coord.s = matrix(runif(100), ncol=2)
coord.r = matrix(runif(50), ncol=2)

d.s = as.matrix(dist(coord.s))
d.r = as.matrix(dist(coord.r))

S1 = exp(-d.s)
S2 = exp(-d.r)

A = t(chol(S1))
B = t(chol(S2))

s = 15
  
x = matrix(runif(nrow(S1)*nrow(S2)*s), ncol=s)

y = kronecker(A,B) \%*\% x

x.solved = forwardsolve.kron(A, B, y)

max(abs(x - x.solved))
}
