% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_BOLD.R
\name{norm_BOLD}
\alias{norm_BOLD}
\title{Normalize BOLD data}
\usage{
norm_BOLD(
  BOLD,
  center_rows = TRUE,
  center_cols = FALSE,
  scale = c("global", "local", "none"),
  scale_sm_xifti = NULL,
  scale_sm_FWHM = 2,
  detrend_DCT = 0
)
}
\arguments{
\item{BOLD}{fMRI numeric data matrix (\eqn{V \times T})}

\item{center_rows, center_cols}{Center BOLD data across rows (each data
location's time series) or columns (each time point's image)? Default:
\code{TRUE} for row centering, and \code{FALSE} for column centering.}

\item{scale}{\code{"global"} (default), \code{"local"}, or \code{"none"}.
Global scaling will divide the entire data matrix by the mean image standard
deviation (\code{mean(sqrt(rowVars(BOLD)))}). Local scaling will divide each
data location's time series by its estimated standard deviation.}

\item{scale_sm_xifti, scale_sm_FWHM}{Only applies if \code{scale=="local"} and
\code{BOLD} represents CIFTI-format data. To smooth the standard deviation
estimates used for local scaling, provide a \code{"xifti"} object with data
locations in alignment with \code{BOLD}, as well as the smoothing FWHM
(default: \code{2}). If no \code{"xifti"} object is provided (default), do
not smooth.}

\item{detrend_DCT}{Detrend the data? This is an integer number of DCT bases
to use for detrending. If \code{0} (default), do not detrend.}
}
\value{
Normalized BOLD data matrix (\eqn{V \times T})
}
\description{
Center the data across space and/or time, detrend, and scale, in that order.
For dual regression, row centering is required and column centering is not
recommended. Scaling and detrending depend on the user preference.
}
