% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_change.R
\name{summarize_change}
\alias{summarize_change}
\alias{s_change_from_baseline}
\alias{a_change_from_baseline}
\title{Summarize the change from baseline or absolute baseline values}
\usage{
summarize_change(
  lyt,
  vars,
  variables,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = vars,
  .stats = c("n", "mean_sd", "median", "range"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_change_from_baseline(df, .var, variables, na.rm = TRUE, ...)

a_change_from_baseline(df, .var, variables, na.rm = TRUE, ...)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \verb{get_stats("analyze_vars_numeric)}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}
}
\value{
\itemize{
\item \code{summarize_change()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_change_from_baseline()} to the table layout.
}

\itemize{
\item \code{s_change_from_baseline()} returns the same values returned by \code{\link[=s_summary.numeric]{s_summary.numeric()}}.
}

\itemize{
\item \code{a_change_from_baseline()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The primary analysis variable \code{.var} indicates the numerical change from baseline results,
and additional required secondary analysis variables are \code{value} and \code{baseline_flag}.
Depending on the baseline flag, either the absolute baseline values (at baseline)
or the change from baseline values (post-baseline) are then summarized.
}
\section{Functions}{
\itemize{
\item \code{summarize_change()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_change_from_baseline()}: Statistics function that summarizes baseline or post-baseline visits.

\item \code{a_change_from_baseline()}: Formatted analysis function which is used as \code{afun} in \code{summarize_change()}.

}}
\note{
To be used after a split on visits in the layout, such that each data subset only contains
either baseline or post-baseline data.

The data in \code{df} must be either all be from baseline or post-baseline visits. Otherwise
an error will be thrown.
}
\examples{
library(dplyr)

## Fabricate dataset
dta_test <- data.frame(
  USUBJID = rep(1:6, each = 3),
  AVISIT = rep(paste0("V", 1:3), 6),
  ARM = rep(LETTERS[1:3], rep(6, 3)),
  AVAL = c(9:1, rep(NA, 9))
) \%>\%
  mutate(ABLFLL = AVISIT == "V1") \%>\%
  group_by(USUBJID) \%>\%
  mutate(
    BLVAL = AVAL[ABLFLL],
    CHG = AVAL - BLVAL
  ) \%>\%
  ungroup()

results <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("AVISIT") \%>\%
  summarize_change("CHG", variables = list(value = "AVAL", baseline_flag = "ABLFLL")) \%>\%
  build_table(dta_test)

results

}
\keyword{internal}
