% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_incidence_rate.R
\name{h_incidence_rate}
\alias{h_incidence_rate}
\alias{h_incidence_rate_normal}
\alias{h_incidence_rate_normal_log}
\alias{h_incidence_rate_exact}
\alias{h_incidence_rate_byar}
\title{Helper functions for incidence rate}
\usage{
h_incidence_rate(person_years, n_events, control = control_incidence_rate())

h_incidence_rate_normal(person_years, n_events, alpha = 0.05)

h_incidence_rate_normal_log(person_years, n_events, alpha = 0.05)

h_incidence_rate_exact(person_years, n_events, alpha = 0.05)

h_incidence_rate_byar(person_years, n_events, alpha = 0.05)
}
\arguments{
\item{person_years}{(\code{numeric(1)})\cr total person-years at risk.}

\item{n_events}{(\code{integer(1)})\cr number of events observed.}

\item{control}{(\code{list})\cr parameters for estimation details, specified by using
the helper function \code{\link[=control_incidence_rate]{control_incidence_rate()}}. Possible parameter options are:
\itemize{
\item \code{conf_level}: (\code{proportion})\cr confidence level for the estimated incidence rate.
\item \code{conf_type}: (\code{string})\cr \code{normal} (default), \code{normal_log}, \code{exact}, or \code{byar}
for confidence interval type.
\item \code{input_time_unit}: (\code{string})\cr \code{day}, \code{week}, \code{month}, or \code{year} (default)
indicating time unit for data input.
\item \code{num_pt_year}: (\code{numeric})\cr time unit for desired output (in person-years).
}}

\item{alpha}{(\code{numeric(1)})\cr two-sided alpha-level for confidence interval.}
}
\value{
Estimated incidence rate, \code{rate}, and associated confidence interval, \code{rate_ci}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{Functions}{
\itemize{
\item \code{h_incidence_rate()}: Helper function to estimate the incidence rate and
associated confidence interval.

\item \code{h_incidence_rate_normal()}: Helper function to estimate the incidence rate and
associated confidence interval based on the normal approximation for the
incidence rate. Unit is one person-year.

\item \code{h_incidence_rate_normal_log()}: Helper function to estimate the incidence rate and
associated confidence interval based on the normal approximation for the
logarithm of the incidence rate. Unit is one person-year.

\item \code{h_incidence_rate_exact()}: Helper function to estimate the incidence rate and
associated exact confidence interval. Unit is one person-year.

\item \code{h_incidence_rate_byar()}: Helper function to estimate the incidence rate and
associated Byar's confidence interval. Unit is one person-year.

}}
\examples{
h_incidence_rate_normal(200, 2)

h_incidence_rate_normal_log(200, 2)

h_incidence_rate_exact(200, 2)

h_incidence_rate_byar(200, 2)

}
\seealso{
\link{incidence_rate}
}
\keyword{internal}
