% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{as.rtable}
\alias{as.rtable}
\alias{as.rtable.data.frame}
\title{Convert to \code{rtable}}
\usage{
as.rtable(x, ...)

\method{as.rtable}{data.frame}(x, format = "xx.xx", ...)
}
\arguments{
\item{x}{(\code{data.frame})\cr the object which should be converted to an \code{rtable}.}

\item{...}{additional arguments for methods.}

\item{format}{(\code{string} or \code{function})\cr the format which should be used for the columns.}
}
\value{
An \code{rtables} table object. Note that the concrete class will depend on the method used.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is a new generic function to convert objects to \code{rtable} tables.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.rtable(data.frame)}: Method for converting a \code{data.frame} that contains numeric columns to \code{rtable}.

}}
\examples{
x <- data.frame(
  a = 1:10,
  b = rnorm(10)
)
as.rtable(x)

}
