% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_logistic.R
\name{control_logistic}
\alias{control_logistic}
\title{Control function for logistic regression model fitting}
\usage{
control_logistic(response_definition = "response", conf_level = 0.95)
}
\arguments{
\item{response_definition}{(\code{string})\cr the definition of what an event is in terms of \code{response}.
This will be used when fitting the logistic regression model on the left hand side of the formula.
Note that the evaluated expression should result in either a logical vector or a factor with 2
levels. By default this is just \code{"response"} such that the original response variable is used
and not modified further.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for logistic regression models.
\code{conf_level} refers to the confidence level used for the Odds Ratio CIs.
}
\examples{
# Standard options.
control_logistic()

# Modify confidence level.
control_logistic(conf_level = 0.9)

# Use a different response definition.
control_logistic(response_definition = "I(response \%in\% c('CR', 'PR'))")

}
