% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticComplexityClass.R
\name{asymptoticComplexityClass}
\alias{asymptoticComplexityClass}
\title{Asymptotic Complexity Classification function}
\usage{
asymptoticComplexityClass(df, output.size, data.size)
}
\arguments{
\item{df}{A data frame composing for two columns at the least, where one should be the contain the output-parameter sizes and one should contain the data sizes.}

\item{output.size}{A string specifying the column name in the passed data frame to be used as the output size.}

\item{data.size}{A string specifying the column name in the passed data frame to be used as the data size.}
}
\value{
A string specifying the resultant complexity class. (Eg: 'Linear', 'Log-linear', 'Quadratic')
}
\description{
Function to classify the complexity trend between two selected parameters from the data frame provided as input here
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Generalized-complexity/
}
\examples{
# Avoiding for CRAN since computation time might exceed 5 seconds sometimes:
\donttest{
# Running the quick sort algorithm with sampling against a set of increasing input data sizes:
sizes = 10^seq(1, 3, by = 0.5)
df <- asymptoticTimings(sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), sizes)
# Classifying the complexity trend between the data contained in the columns
# 'Timings' and 'Data sizes' from the data frame obtained above:
asymptoticComplexityClass(df, output.size = "Timings", data.size = "Data sizes")
# For quick sort, the log-linear time complexity class is expected.
}
}
