% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormatRawLdaOutput.R
\name{FormatRawLdaOutput}
\alias{FormatRawLdaOutput}
\title{Format Raw Output from lda::lda.collapsed.gibbs.sampler()}
\usage{
FormatRawLdaOutput(lda.result, docnames, smooth = TRUE)
}
\arguments{
\item{lda.result}{The list value returned by lda.collapsed.gibbs.sampler()}

\item{docnames}{A character vector giving the names of documents. This is generally rownames(dtm).}

\item{smooth}{Logical. Do you want to smooth your topic proportions so that 
there is a positive value for each term in each topic? Defaults to TRUE}
}
\value{
Returns a \code{list} with two elements: \code{phi} whose rows represent the 
distribution of words across a topic and \code{theta} whose rows represent 
the distribution of topics across a document.
}
\description{
extracts outputs from LDA model estimated with \code{lda} package by Jonathan Chang
}
\examples{
# Load a pre-formatted dtm and topic model
data(nih_sample_dtm) 

# re-create a character vector of documents from the DTM
lex <- Dtm2Docs(nih_sample_dtm)

# Format for input to lda::lda.collapsed.gibbs.sampler
lex <- lda::lexicalize(lex, vocab=colnames(nih_sample_dtm))

# Fit the model from lda::lda.collapsed.gibbs.sampler
lda <- lda::lda.collapsed.gibbs.sampler(documents = lex, K = 100, 
                                         vocab = colnames(nih_sample_dtm), 
                                         num.iterations=200, 
                                         alpha=0.1, eta=0.05)
                                         
# Format the result to get phi and theta matrices                                        
lda <- FormatRawLdaOutput(lda.result=lda, docnames=rownames(nih_sample_dtm), smooth=TRUE)

}

