% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_core.R
\name{Dtm2Lexicon}
\alias{Dtm2Lexicon}
\title{Turn a document term matrix into a list for LDA Gibbs sampling}
\usage{
Dtm2Lexicon(dtm, ...)
}
\arguments{
\item{dtm}{A document term matrix (or term co-occurrence matrix) of class 
\code{dgCMatrix}.}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}.}
}
\value{
Returns a list. Each element of the list represents a row of the input
matrix. Each list element contains a numeric vector with as many entries as
tokens in the original document. The entries are the column index for that token, minus 1.
}
\description{
Represents a document term matrix as a list.
}
\examples{
\dontrun{
# Load pre-formatted data for use
data(nih_sample_dtm)

result <- Dtm2Lexicon(dtm = nih_sample_dtm, 
                      cpus = 2)
}
}
