% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenmerge.R
\name{step_tokenmerge}
\alias{step_tokenmerge}
\alias{tidy.step_tokenmerge}
\title{Generate the basic set of text features}
\usage{
step_tokenmerge(recipe, ..., role = "predictor", trained = FALSE,
  columns = NULL, prefix = "tokenmerge", skip = FALSE,
  id = rand_id("tokenmerge"))

\method{tidy}{step_tokenmerge}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For `step_tokenmerge`, this indicates the variables to be encoded
into a list column. See [recipes::selections()] for more
details. For the `tidy` method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be 
used as predictors in a model.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is `NULL` until the step is trained by
[recipes::prep.recipe()].}

\item{prefix}{A prefix for generated column names, default to "tokenmerge".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by [recipes::bake.recipe()]? While all
operations are baked when [recipes::prep.recipe()] is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using `skip = TRUE` as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it}

\item{x}{A `step_tokenmerge` object.}
}
\value{
An updated version of `recipe` with the new step added
 to the sequence of existing steps (if any).
}
\description{
`step_tokenmerge` creates a *specification* of a recipe step that
 will take multiple list-columns of tokens and combine them into one 
 list-column.
}
\examples{
library(recipes)

data(okc_text)

okc_rec <- recipe(~ ., data = okc_text) \%>\%
  step_tokenize(essay0, essay1) \%>\%
  step_tokenmerge(essay0, essay1) 
  
okc_obj <- okc_rec \%>\%
  prep(training = okc_text, retain = TRUE)

juice(okc_obj)
  
tidy(okc_rec, number = 1)
tidy(okc_obj, number = 1)

}
