% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/um.R
\name{autocov.stsm}
\alias{autocov.stsm}
\alias{autocov}
\alias{autocov.um}
\title{Theoretical autocovariances of an ARMA model}
\usage{
\method{autocov}{stsm}(mdl, ...)

autocov(mdl, ...)

\method{autocov}{um}(mdl, lag.max = 10, ...)
}
\arguments{
\item{mdl}{an object of class \code{um} or \code{stsm}.}

\item{...}{additional arguments.}

\item{lag.max}{maximum lag for autocovariances.}
}
\value{
A numeric vector.
}
\description{
\code{autocov} computes the autocovariances of an ARMA model.
}
\note{
The I polynomial is ignored.
}
\examples{
# Local level model
b <- 1
C <- as.matrix(1)
stsm1 <- stsm(b = b, C = C, s2v = c(lvl = 1469.619), s2u = c(irr = 15103.061))
autocov(stsm1)

ar1 <- um(ar = "1-0.8B")
autocov(ar1, lag.max = 13)

}
