% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_assert.R
\name{tf_assert}
\alias{tf_assert}
\title{tf_assert}
\usage{
tf_assert(
  condition,
  ...,
  expr = substitute(condition),
  summarize = NULL,
  name = NULL
)
}
\arguments{
\item{condition}{A boolean tensor}

\item{...}{Additional elements passed on to \code{data}. (e.g, an informative
error message as a string, additional tensor values that might be useful to
have in the error message, etc.)}

\item{expr}{A language object, provided in case \code{condition} is already
computed prior to the call}

\item{summarize}{Print this many entries of each tensor.}

\item{name}{A name for this operation (optional).}
}
\description{
A thin wrapper around \code{tf$Assert()} that automatically constructs an
informative error message (passed on to \code{data} argument), which includes the
expression passed to \code{condition}, the values of the symbols found in the
expression, as well as the full R call stack at the time the \code{tf$Assert()}
node is created.
}
\examples{
\dontrun{
x <- tf$constant(-1)
try(tf_assert(x > 0, "oopsies! x must be greater than 0"))
}
}
