% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{collect_events}
\alias{collect_events}
\alias{events_logdir}
\title{Collect data from tfevents records}
\usage{
collect_events(
  logdir = get_default_logdir(),
  n = NULL,
  type = c("any", "summary", "scalar")
)

events_logdir(logdir = get_default_logdir())
}
\arguments{
\item{logdir}{The log directory that you want to query events from. Either a
file path or a connection created with \code{\link[=events_logdir]{events_logdir()}}.}

\item{n}{The maximum number of events to read from the connection. If \code{NULL}
then all events are read, the default is \code{NULL}.}

\item{type}{The kind of events that are to be read. By default all events are
read. If a different type is specified, then the result can include other
columns as well as more lines.}
}
\value{
A \code{tibble} with the collected events.
}
\description{
Collects all events of a kind in a single data.frame ready for analysis.
}
\section{Functions}{
\itemize{
\item \code{events_logdir()}: Creates a connection to a logdir that can be reused
to read further events later.

}}
\examples{
temp <- tempfile()
with_logdir(temp, {
  for(i in 1:5) {
    log_event(my_log = runif(1))
  }
})
# collect all events in files, including file description events
collect_events(temp)
# collect summaries in the logdir
collect_events(temp, type = "summary")
# collect only scalar events
collect_events(temp, type = "scalar")

}
