% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audio.R
\name{summary_audio}
\alias{summary_audio}
\alias{summary_audio.array}
\alias{summary_audio.raw}
\alias{summary_audio.blob}
\title{Summary audio}
\usage{
summary_audio(audio, ..., metadata = NULL, tag = NA)

\method{summary_audio}{array}(audio, ..., sample_rate = 44100, metadata = NULL, tag = NA)

\method{summary_audio}{raw}(audio, ..., metadata = NULL, tag = NA)

\method{summary_audio}{blob}(audio, ..., metadata = NULL, tag = NA)
}
\arguments{
\item{audio}{Object that will be written as an audio event in the tfevents record.}

\item{...}{Currently unused.}

\item{metadata}{A \code{metadata} object, as created with \code{\link[=summary_metadata]{summary_metadata()}}. In
most cases you don't need to change the default.}

\item{tag}{A tag that within the TensorBoard UI. See \code{\link[=log_event]{log_event()}} for other
ways of specifying the tag attribute.}

\item{sample_rate}{The sample rate in Hz associated to the audio values.}
}
\value{
An audio summary that can be logged with \code{\link[=log_event]{log_event()}}.
}
\description{
Audio summaries can be played withing the TensorBoard UI.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary_audio(array)}: Creates a summary from a 3D array with dimensions
\verb{(batch_size, n_samples, n_channels)}. Values must be in the range \verb{[-1, 1]}.

\item \code{summary_audio(raw)}: Creates an audio summary from a raw vector containing
a WAV encoded audio file.

\item \code{summary_audio(blob)}: Creates an audio summary from a blob (ie list of raw vectors)
containing WAV encoded audio files.

}}
\examples{
tmp <- tempfile()
with_logdir(tmp, {
  summary_audio(array(runif(100), dim = c(1,100, 1)))
})
}
\seealso{
Other summary: 
\code{\link{summary_histogram}()},
\code{\link{summary_image}()},
\code{\link{summary_scalar}()},
\code{\link{summary_text}()}
}
\concept{summary}
