% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_low_dimension.R
\name{plot_low_dimension}
\alias{plot_low_dimension}
\title{Produce a principal components analysis (PCA) on normalised feature values and render a bivariate plot to visualise it}
\usage{
plot_low_dimension(
  data,
  is_normalised = FALSE,
  id_var = "id",
  group_var = NULL,
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  low_dim_method = c("PCA", "t-SNE"),
  perplexity = 30,
  plot = TRUE,
  show_covariance = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{a dataframe with at least 2 columns called \code{"names"} and \code{"values"}}

\item{is_normalised}{a Boolean as to whether the input feature values have already been scaled. Defaults to \code{FALSE}}

\item{id_var}{a string specifying the ID variable to uniquely identify each time series. Defaults to \code{"id"}}

\item{group_var}{a string specifying the grouping variable that the data aggregates to (if one exists). Defaults to \code{NULL}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"z-score"}}

\item{low_dim_method}{the low dimensional embedding method to use. Defaults to \code{"PCA"}}

\item{perplexity}{the perplexity hyperparameter to use if t-SNE algorithm is selected. Defaults to \code{30}}

\item{plot}{a Boolean as to whether a plot or model fit information should be returned. Defaults to \code{TRUE}}

\item{show_covariance}{a Boolean as to whether covariance ellipses should be shown on the plot. Defaults to \code{FALSE}}

\item{seed}{fixed number for R's random number generator to ensure reproducibility}
}
\value{
if \code{plot = TRUE}, returns an object of class \code{ggplot}, if \code{plot = FALSE} returns an object of class dataframe with PCA results
}
\description{
Produce a principal components analysis (PCA) on normalised feature values and render a bivariate plot to visualise it
}
\examples{
\donttest{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)

plot_low_dimension(featMat, 
  is_normalised = FALSE, 
  id_var = "id", 
  group_var = "group", 
  method = "RobustSigmoid", 
  low_dim_method = "PCA", 
  plot = TRUE,
  show_covariance = TRUE,
  seed = 123)
}

}
\author{
Trent Henderson
}
