% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{filter_conditional_independencies}
\alias{filter_conditional_independencies}
\title{Filter Conditional Independencies}
\usage{
filter_conditional_independencies(x, data)
}
\arguments{
\item{x}{An object of class \code{dagitty.cis}.}

\item{data}{A \code{data.frame}.}
}
\value{
An object of class \code{dagitty.cis}, or \code{NULL} if no conditional
independencies remain.
}
\description{
Removes all conditional independencies, obtained using
\link[dagitty]{impliedConditionalIndependencies}, based on the variables
available in \code{data}.
}
\examples{
dag <- dagitty::dagitty('dag {
x1 -> y
x2 -> y}')
df <- data.frame(x1 = rnorm(10), y = rnorm(10))
cis <- dagitty::impliedConditionalIndependencies(dag)
cis <- filter_conditional_independencies(cis, df)
is.null(cis)
}
\seealso{
\code{\link[dagitty]{impliedConditionalIndependencies}}
}
