% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.glm.R
\name{.model.glm}
\alias{.model.glm}
\title{Generalized linear regression for \code{tidyfit}}
\usage{
\method{.model}{glm}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a linear or logistic regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{stats::glm}. See \code{?glm} for more details.

\strong{Implementation}

\emph{No implementation notes}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data$Return <- ifelse(data$Return > 0, 1, 0)

# Stand-alone function
fit <- m("glm", Return ~ ., data)
fit

# Within 'classify' function
fit <- classify(data, Return ~ ., m("glm"), .mask = c("Date", "Industry"))
coef(fit)

}
\seealso{
\code{\link{.model.lm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
