% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.quantile.R
\name{.fit.quantile}
\alias{.fit.quantile}
\title{Quantile regression for \code{tidyfit}}
\usage{
\method{.fit}{quantile}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a linear quantile regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{tau} (the quantile(s) to be estimated)
}

The function provides a wrapper for \code{quantreg::rq}. See \code{?rq} for more details. The argument \code{tau} is the chosen quantile (default \code{tau = 0.5}).

\strong{Implementation}

\emph{No implementation notes}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("quantile", Return ~ ., data, tau = 0.5)
fit

# Within 'regress' function
fit <- regress(data, Return ~ .,
               m("quantile", tau = c(0.1, 0.5, 0.9)),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Koenker R (2022). \emph{quantreg: Quantile Regression}. R package version 5.94, \url{https://CRAN.R-project.org/package=quantreg}.
}
\seealso{
\code{\link{.fit.lm}}, \code{\link{.fit.bayes}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
