% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidymat.R
\name{mat_df}
\alias{mat_df}
\alias{df_mat}
\title{Conversion between tidy table and named matrix}
\usage{
mat_df(m)

df_mat(df, row, col, value)
}
\arguments{
\item{m}{A matrix}

\item{df}{A data.frame with at least 3 columns, one for row name,
one for column name, and one for values. The names for column and
row should be unique.}

\item{row}{Unquoted expression of column name for row}

\item{col}{Unquoted expression of column name for column}

\item{value}{Unquoted expression of column name for values}
}
\value{
For \code{mat_df}, a data.frame.
For \code{df_mat}, a named matrix.
}
\description{
Convenient fucntions to implement conversion between
 tidy table and named matrix.
}
\examples{

mm = matrix(c(1:8,NA),ncol = 3,dimnames = list(letters[1:3],LETTERS[1:3]))
mm
tdf = mat_df(mm)
tdf
mat = df_mat(tdf,row,col,value)
setequal(mm,mat)

tdf \%>\%
  setNames(c("A","B","C")) \%>\%
  df_mat(A,B,C)

}
