% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_dt.R
\name{count_dt}
\alias{count_dt}
\alias{add_count_dt}
\title{Count observations by group}
\usage{
count_dt(.data, ..., sort = TRUE, .name = "n")

add_count_dt(.data, ..., .name = "n")
}
\arguments{
\item{.data}{data.table/data.frame data.frame will be automatically converted
to data.table.}

\item{...}{Variables to group by, could receive what `select_dt` receives.}

\item{sort}{logical. If TRUE result will be sorted in desending order by resulting variable.}

\item{.name}{character. Name of resulting variable. Default uses "n".}
}
\value{
data.table
}
\description{
Count the unique values of one or more variables.
}
\examples{
iris \%>\% count_dt(Species)
iris \%>\% count_dt(Species,.name = "count")
iris \%>\% add_count_dt(Species)
iris \%>\% add_count_dt(Species,.name = "N")

mtcars \%>\% count_dt(cyl,vs)
mtcars \%>\% count_dt("cyl|vs")
mtcars \%>\% count_dt(cyl,vs,.name = "N",sort = FALSE)
mtcars \%>\% add_count_dt(cyl,vs)
mtcars \%>\% add_count_dt("cyl|vs")

}
\seealso{
\code{\link[dplyr]{count}}
}
