% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo.R
\name{reverse_geo}
\alias{reverse_geo}
\title{Reverse geocode coordinates}
\usage{
reverse_geo(
  lat,
  long,
  method = "osm",
  address = address,
  limit = 1,
  min_time = NULL,
  api_url = NULL,
  timeout = 20,
  mode = "",
  full_results = FALSE,
  unique_only = FALSE,
  return_coords = TRUE,
  flatten = TRUE,
  batch_limit = NULL,
  verbose = FALSE,
  no_query = FALSE,
  custom_query = list(),
  iq_region = "us",
  geocodio_v = 1.6,
  mapbox_permanent = FALSE,
  here_request_id = NULL,
  mapquest_open = FALSE
)
}
\arguments{
\item{lat}{latitude values (input data)}

\item{long}{longitude values (input data)}

\item{method}{the geocoder service to be used. API keys are loaded from environmental variables. Run \code{usethis::edit_r_environ()} to open your .Renviron file and add an API key as an environmental variable. For example, add the line \code{GEOCODIO_API_KEY="YourAPIKeyHere"}.
\itemize{
\item \code{"osm"}: \href{https://nominatim.org}{Nominatim}.
\item \code{"arcgis"}: \href{https://developers.arcgis.com/rest/geocode/api-reference/overview-world-geocoding-service.htm}{ArcGIS}.
\item \code{"geocodio"}: \href{https://www.geocod.io/}{Geocodio}. Geographic coverage is limited to the United States and Canada. An API key must be stored in "GEOCODIO_API_KEY". Batch geocoding is supported.
\item \code{"iq"}: \href{https://locationiq.com/}{Location IQ}.  An API key must be stored in "LOCATIONIQ_API_KEY".
\item \code{"google"}: \href{https://developers.google.com/maps/documentation/geocoding/overview}{Google}.  An API key must be stored in "GOOGLEGEOCODE_API_KEY".
\item \code{"opencage"}: \href{https://opencagedata.com}{OpenCage}.  An API key must be stored in "OPENCAGE_KEY".
\item \code{"mapbox"}: \href{https://docs.mapbox.com/api/search/}{Mapbox}.  An API key must be stored in "MAPBOX_API_KEY".
\item \code{"here"}: \href{https://developer.here.com/products/geocoding-and-search}{HERE}.  An API key must be stored in "HERE_API_KEY". Batch geocoding is supported, but must be explicitly called with \code{mode = "batch"}.
\item \code{"tomtom"}: \href{https://developer.tomtom.com/search-api/search-api-documentation/geocoding}{TomTom}.  An API key must be stored in "TOMTOM_API_KEY". Batch geocoding is supported.
\item \code{"mapquest"}: \href{https://developer.mapquest.com/documentation/geocoding-api/}{MapQuest}.  An API key must be stored in "MAPQUEST_API_KEY". Batch geocoding is supported.
\item \code{"bing"}: \href{https://docs.microsoft.com/en-us/bingmaps/rest-services/locations/}{Bing}.  An API key must be stored in "BINGMAPS_API_KEY". Batch geocoding is supported, but must be explicitly called with \code{mode = "batch"}.
}}

\item{address}{name of the address column (in the output data)}

\item{limit}{maximum number of results to return per input coordinate. For many geocoder services
the maximum value of the limit parameter is 100. Pass \code{limit = NULL} to use
the default \code{limit} value of the selected geocoder service.
For batch geocoding, limit must be set to 1 (default) if \code{return_coords = TRUE}.
Refer to \link{api_parameter_reference} for more details.}

\item{min_time}{minimum amount of time for a query to take (in seconds). If NULL
then min_time will be set to the default value specified in \link{min_time_reference}.}

\item{api_url}{custom API URL. If specified, the default API URL will be overridden.
This parameter can be used to specify a local Nominatim server, for instance.}

\item{timeout}{query timeout (in minutes)}

\item{mode}{set to 'batch' to force batch geocoding or 'single' to force single coordinate
geocoding (one coordinate per query). If not specified then batch geocoding will
be used if available (given method selected) when multiple coordinates are
provided; otherwise single address geocoding will be used. For the "here" and "bing" methods the
batch mode should be explicitly specified with \code{mode = 'batch'}.}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only a single address column will be returned from the geocoder service.}

\item{unique_only}{only return results for unique inputs if TRUE}

\item{return_coords}{return input coordinates with results if TRUE. Note that
most services return the input coordinates with \code{full_results = TRUE} and setting
\code{return_coords} to FALSE does not prevent this.}

\item{flatten}{if TRUE then any nested dataframes in results are flattened if possible.
Note that in some cases results are flattened regardless such as for
Geocodio batch geocoding.}

\item{batch_limit}{limit to the number of coordinates in a batch geocoding query.
Defaults to the value in \link{batch_limit_reference} if not specified.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{no_query}{if TRUE then no queries are sent to the geocoder service and verbose is set to TRUE.
Used for testing.}

\item{custom_query}{API-specific parameters to be used, passed as a named list
(ie. \code{list(extratags = 1)}.}

\item{iq_region}{"us" (default) or "eu". Used for establishing the API URL for the "iq" method.}

\item{geocodio_v}{version of geocodio API. Used for establishing the API URL
for the "geocodio" method.}

\item{mapbox_permanent}{if TRUE then the \code{mapbox.places-permanent}
endpoint would be used. Note that this option should be used only if you
have applied for a permanent account. Unsuccessful requests made by an
account that does not have access to the endpoint may be billable.}

\item{here_request_id}{This parameter would return a previous HERE batch job,
identified by its RequestID. The RequestID of a batch job is displayed
when \code{verbose = TRUE}. Note that this option would ignore the
current \verb{lat, long} parameters on the request, so \code{return_coords}
needs to be FALSE.}

\item{mapquest_open}{if TRUE then MapQuest would use the Open Geocoding
endpoint, that relies solely on data contributed to OpenStreetMap.}
}
\value{
tibble (dataframe)
}
\description{
Reverse geocodes geographic coordinates (latitude and longitude) given as numeric values.
Latitude and longitude inputs are limited to possible values. Latitudes must be between -90 and 90 and
longitudes must be between -180 and 180. Invalid values will not be sent to the geocoder service.
The \link{reverse_geocode} function utilizes this function on coordinates contained in dataframes.
See example usage in \code{vignette("tidygeocoder")}.

Refer to \link{api_parameter_reference},
\link{min_time_reference}, and \link{batch_limit_reference} for more details on
geocoder service parameters and usage.

This function uses the \link{get_api_query}, \link{query_api}, and
\link{extract_reverse_results} functions to create, execute, and parse geocoder
API queries.
}
\examples{
\donttest{
 reverse_geo(lat = 38.895865, long = -77.0307713, method = 'osm', verbose = TRUE)
 
 reverse_geo(
   lat = c(38.895865, 43.6534817, 300), 
   long = c(-77.0307713, -79.3839347, 600),
   method = 'osm', full_results = TRUE, verbose = TRUE
 )
 
}
}
\seealso{
\link{reverse_geocode} \link{api_parameter_reference} \link{min_time_reference} \link{batch_limit_reference}
}
