% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_mmd.R
\name{tx_mmd}
\alias{tx_mmd}
\title{Subset active clients based on months of ARV Dispensed}
\usage{
tx_mmd(
  data,
  months = NULL,
  states = NULL,
  facilities = NULL,
  status = "default",
  remove_duplicates = FALSE
)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{months}{The number(s) of months of interest of ARV dispensed. The default is to subset active
clients who had 3 - 6 months of ARV dispensed.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{remove_duplicates}{Boolean argument. It specifies if duplicate patient entries in the facilities should be removed or kept}
}
\value{
tx_mmd
}
\description{
Generates list of clients who had 3 - 6 months of ARV dispensed during the
medication refill. You can specify the number of month(s) of ARV dispensed
by changing the \code{month} argument.
}
\examples{
tx_mmd(ndr_example)

# subset active clients who had 2 or 4 months of ARV dispensed at last encounter
tx_mmd(ndr_example,
  months = c(2, 4),
  status = "default"
)
}
