% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsemodel.R
\name{parse_model}
\alias{parse_model}
\title{Converts an R model object into a table}
\usage{
parse_model(model)
}
\arguments{
\item{model}{An R model object.}
}
\description{
It parses a fitted R model's structure and extracts the components
needed to create a dplyr formula for prediction.  The function also
creates a data frame using an specific format so that other
functions in the future can also pass parsed tables to a given
formula creating function.
}
\examples{
library(dplyr)
df <- mutate(mtcars, cyl = paste0("cyl", cyl))
model <- lm(mpg ~ wt + cyl * disp, offset = am, data = df)
parse_model(model)
}
