% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptable.R
\name{acceptable_formula}
\alias{acceptable_formula}
\title{Checks that the formula can be parsed}
\usage{
acceptable_formula(model)
}
\arguments{
\item{model}{An R model object}
}
\description{
Uses an S3 method to check that a given formula can be parsed based on its class.
It currently scans for contrasts that are not supported and in-line functions.
(e.g: lm(wt ~ as.factor(am))). Sine this function is meant for function interaction,
as opposed to human interaction, a successful check is silent.
}
\examples{

model <- lm(mpg ~ wt, mtcars)
acceptable_formula(model)
}
