% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_class_thresh.R
\name{calib_class_thresh}
\alias{calib_class_thresh}
\title{Calibrate class thresholds}
\usage{
calib_class_thresh(object, class_thresh, metric_thresh = NULL)
}
\arguments{
\item{object}{an simple_ensemble object}

\item{class_thresh}{probability threshold used to convert probabilities into
classes. It can be a number (between 0 and 1), or a character metric
(currently "tss_max", "kap_max" or "sensitivity"). For sensitivity, an
additional target value is passed along as a second element of a vector,
e.g. c("sensitivity",0.8).}

\item{metric_thresh}{a vector of length 2 giving a metric and its threshold,
which will be used to prune which models in the ensemble will be used for
the prediction. The 'metrics' need to have been computed when the workflow
was tuned. The metric's threshold needs to match the value used during
prediction. Examples are c("accuracy",0.8) or c("boyce_cont",0.7).}
}
\value{
a \link{simple_ensemble} object
}
\description{
Predict for a new dataset by using a simple ensemble. Predictions from
individual models are combined according to \code{fun}
}
\examples{
test_ens <- simple_ensemble() \%>\%
  add_member(two_class_res[1:3, ], metric = "roc_auc")
test_ens <- calib_class_thresh(test_ens, class_thresh = "tss_max")
test_ens <- calib_class_thresh(test_ens, class_thresh = "kap_max")
test_ens <- calib_class_thresh(test_ens, class_thresh = c("sens", 0.9))
}
\keyword{predict}
